clear
cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

clear
tempfile data
cap gen date = 0
keep if _n < 0
sort date
save "`data'", replace

foreach type in tavg tmin tmax {
	use merged_results_`type'.dta, clear
	sort date
	merge date using "`data'"
	drop _merge
	sort date
	save "`data'", replace
}

use "`data'", clear
sort gridbox
save "`data'", replace
	
sort gridbox
collapse (count) date, by(gridbox)	
drop date
gen gridbox_id = _n
sort gridbox

merge gridbox using "`data'"
drop _merge

keep if yofd(dofm(date)) >= 2004
save "`data'", replace

tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues gridbox_id = 1(1)88 {
	local type tmax
	use "`data'", clear
	keep if gridbox_id == `gridbox_id'
	gen raw_diff = ushcn_`type'_raw - uscrn_`type'
	gen adj_diff = ushcn_`type'_adj - uscrn_`type'
	reg raw_diff date
	regsave using "`results'", ci append replace addlabel(dataset, `type', gridbox, `gridbox_id', adjustments, raw)
	reg adj_diff date
	regsave using "`results'", ci append replace addlabel(dataset, `type', gridbox, `gridbox_id', adjustments, adj)
}

use "`results'", clear

drop if var == "_cons"
twoway scatter coef gridbox if adjustment == "raw", mcolor(blue) || scatter coef gridbox if adjustment == "adj", mcolor(red)

